% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainIMGT.R
\name{loadIMGT}
\alias{loadIMGT}
\title{Load Cached IMGT/HLA Sequences}
\usage{
loadIMGT(
  species = "human",
  gene,
  type = c("NUC", "PROT"),
  suppressMessages = FALSE
)
}
\arguments{
\item{species}{Character string specifying the species for which to download
data. Required for TCR/BCR queries. Currently supported species:
\code{"human"}, \code{"mouse"}, \code{"rat"}, \code{"rabbit"}, \code{"pig"},
\code{"dog"}, \code{"rhesus_monkey"}, \code{"cyno_monkey"}. Defaults to
\code{"human"} for HLA queries.}

\item{gene}{Character string specifying the gene or locus to download. For
TCR/BCR, this can be a specific chain (e.g., \code{"IGHV"}, \code{"TRBJ"})
or a group (e.g., \code{"IGH"}, \code{"TCR"}). For HLA, use \code{"HLA"}.}

\item{type}{Character string specifying the type of sequence to retrieve.
Either \code{"NUC"} for nucleotide or \code{"PROT"} for protein sequences.
This primarily distinguishes between VDJ nucleotide and V-region amino acid
sequences for TCR/BCR genes.}

\item{suppressMessages}{Logical. If \code{TRUE}, suppresses the license and
other informational messages. Default is \code{FALSE}.}
}
\value{
A \code{\link[Biostrings]{DNAStringSet}} object (when
  \code{type = "NUC"}) or \code{\link[Biostrings]{AAStringSet}} object (when
  \code{type = "PROT"}) containing the requested sequences.
}
\description{
Loads sequences from the local cache without attempting to
download. This function is a convenience wrapper for
\code{getIMGT(refresh = FALSE)}. If the data is not found in the cache, it
will be downloaded unless an internet connection is unavailable.
}
\examples{
if(is_imgt_available()) {
  # First, download a file to ensure it's in the cache
  getIMGT(species = "human", gene = "IGHV", type = "NUC", suppressMessages = TRUE)
  # Now, load it from the cache
  ighv_cached <- loadIMGT(species = "human", gene = "IGHV", type = "NUC")
}
}
\seealso{
\code{\link{getIMGT}} for the main download function

\code{\link{refreshIMGT}} to force re-download
}
