% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainIMGT.R
\name{getIMGT}
\alias{getIMGT}
\title{Download and Load Immune Receptor and HLA Sequences from IMGT}
\usage{
getIMGT(
  species = "human",
  gene,
  type = c("NUC", "PROT"),
  refresh = FALSE,
  suppressMessages = FALSE
)
}
\arguments{
\item{species}{Character string specifying the species for which to download
data. Required for TCR/BCR queries. Currently supported species:
\code{"human"}, \code{"mouse"}, \code{"rat"}, \code{"rabbit"}, \code{"pig"},
\code{"dog"}, \code{"rhesus_monkey"}, \code{"cyno_monkey"}. Defaults to
\code{"human"} for HLA queries.}

\item{gene}{Character string specifying the gene or locus to download. For
TCR/BCR, this can be a specific chain (e.g., \code{"IGHV"}, \code{"TRBJ"})
or a group (e.g., \code{"IGH"}, \code{"TCR"}). For HLA, use \code{"HLA"}.}

\item{type}{Character string specifying the type of sequence to retrieve.
Either \code{"NUC"} for nucleotide or \code{"PROT"} for protein sequences.
This primarily distinguishes between VDJ nucleotide and V-region amino acid
sequences for TCR/BCR genes.}

\item{refresh}{Logical. If \code{TRUE}, forces a re-download of the data even
if it exists in the cache. Default is \code{FALSE}.}

\item{suppressMessages}{Logical. If \code{TRUE}, suppresses the license and
other informational messages. Default is \code{FALSE}.}
}
\value{
A \code{\link[Biostrings]{DNAStringSet}} object (when
  \code{type = "NUC"}) or \code{\link[Biostrings]{AAStringSet}} object (when
  \code{type = "PROT"}) containing the requested sequences.
}
\description{
This is the main function to download and load reference
sequences from IMGT and the IPD-IMGT/HLA database. It handles caching of
downloaded files.
}
\examples{
if(is_imgt_available()) {
  # Download human IGHV nucleotide sequences
  ighv_nuc <- getIMGT(species = "human",
                      gene = "IGHV",
                      type = "NUC")

  # Download all HLA protein sequences
  hla_prot <- getIMGT(gene = "HLA",
                      type = "PROT")

  # Download all mouse TRB genes
  trb_mouse <- getIMGT(species = "mouse",
                      gene = "TRB",
                      type = "NUC")
}

}
\seealso{
\code{\link{loadIMGT}}, \code{\link{refreshIMGT}} for convenience wrappers

\code{\link{getOGRDB}} for OGRDB/AIRR-C germline sequences

\code{\link{exportMiXCR}}, \code{\link{exportTRUST4}},
\code{\link{exportCellRanger}}, \code{\link{exportIgBLAST}} for exporting
sequences to analysis tools
}
