% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probabilityMatrix.R
\name{probabilityMatrix}
\alias{probabilityMatrix}
\title{Position Probability Matrix for Amino Acid or Nucleotide Sequences}
\usage{
probabilityMatrix(
  input.sequences,
  max.length = NULL,
  convert.PWM = FALSE,
  background.frequencies = NULL,
  sequence.dictionary = amino.acids,
  pseudocount = 1,
  padding.symbol = "."
)
}
\arguments{
\item{input.sequences}{Character vector of sequences.}

\item{max.length}{Integer; sequences will be right-padded to this length. 
If NULL (default), pads to the length of the longest sequence in the input.}

\item{convert.PWM}{Logical; if TRUE, converts the matrix into a PWM.}

\item{background.frequencies}{Named vector of background frequencies for PWM 
calculation. If NULL, a uniform distribution is assumed. Names must 
correspond to characters in `sequence.dictionary`.}

\item{sequence.dictionary}{Character vector of residues to include in the matrix.}

\item{pseudocount}{A small number added to raw counts for PWM calculation to 
avoid zero probabilities. Defaults to 1.}

\item{padding.symbol}{Single character for right-padding. Must not be in `sequence.dictionary`.}
}
\value{
A matrix with position-specific probabilities (PPM) or weights (PWM).
}
\description{
Generates a position-probability (PPM) or position-weight (PWM) matrix
from a set of biological sequences.
}
\examples{
new.sequences <- generateSequences(prefix.motif = "CAS",
                                   suffix.motif = "YF",
                                   number.of.sequences = 100,
                                   min.length = 8,
                                   max.length = 16)
                          
PPM.matrix <- probabilityMatrix(new.sequences)

}
