% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateProperty.R
\name{calculateProperty}
\alias{calculateProperty}
\title{Position-wise Amino-Acid Property Profiles}
\usage{
calculateProperty(
  input.sequences,
  property.set = "atchleyFactors",
  summary.fun = "mean",
  transform = "none",
  max.length = NULL,
  padding.symbol = ".",
  tidy = FALSE
)
}
\arguments{
\item{input.sequences}{Character vector of amino-acid strings.}

\item{property.set}{Character string (one of the supported names) 
Defaults to `"atchleyFactors"`, but includes: `"crucianiProperties"`, 
`"FASGAI"`, `"kideraFactors"`, `"MSWHIM"`, `"ProtFP"`, `"stScales"`, 
`"tScales"`, `"VHSE"`, `"zScales"`}

\item{summary.fun}{Character string (`"mean"`, `"median"`, `"sum"`,
`"min"`, `"max"`), **or** a function accepting a numeric vector and
returning length-1 numeric.  Defaults to `"mean"`.}

\item{transform}{Character string controlling a *post-summary*
transformation. One of  `"none"` (default), `"sqrt"`, `"log1p"`, 
`"zscore"` (row-wise), or `"minmax"` (row-wise).}

\item{max.length}{Integer. Pad/trim to this length
(`max(nchar(sequences))` by default).}

\item{padding.symbol}{Single character used for right-padding. Must not be
one of the 20 canonical residues.}

\item{tidy}{Logical; if `TRUE`, return a long-format `data.frame`}
}
\value{
A numeric matrix (*k* × *L*) **or** a tidy data.frame with columns
scale, position, value.
}
\description{
Computes a range of summary statistics for property values of one or more AA 
property scales at every residue position of a set of protein (or peptide) 
sequences. The function is entirely vectorized: it first calls 
[`calculateFrequency()`] to obtain a residue-by-position **frequency** 
matrix *F* (each column sums to 1) and then performs a single matrix product.
}
\examples{
set.seed(1)
seqs <- c("CASSLGQGAETQYF", "CASSPGQGDYEQYF", "CASSQETQYF")
aa.Atchley <- calculateProperty(seqs, property.set = "atchleyFactors")

}
