% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity.R
\name{ace_richness}
\alias{ace_richness}
\title{ACE Richness Estimator}
\usage{
ace_richness(cnt)
}
\arguments{
\item{cnt}{Numeric vector of non-negative counts (one entry per clone/
residue/OTU).  Zero counts are ignored.}
}
\value{
A single numeric value representing the estimated total number of
  species. The estimate is constrained to be at least the number of
  observed species.
}
\description{
Calculates the Abundance-based Coverage Estimator (ACE) of species richness.
This metric is particularly useful for datasets with a large number of rare
species.
}
\details{
\deqn{S_{ace} = S_{abund} + \frac{S_{rare}}{C_{ace}} + \frac{F_1}{C_{ace}} \gamma^2_{ace}}

where the classification of rare and abundant species is based on a
threshold of 10 individuals, *F*1 is the count of singletons,
*S*rare is the number of rare species, and *C*ace is the
sample coverage for rare species.
}
\examples{
counts <- rpois(50, lambda=1.5)
ace_richness(counts)
}
\references{
Chao, A., & Lee, S.-M. (1992). *Estimating the number of classes via sample coverage*.
Journal of the American Statistical Association, 87(417), 210-217.
}
