% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patchSize.R
\name{patchSize}
\alias{patchSize}
\title{Function to compute the area of c3ll patches}
\usage{
patchSize(
  object,
  patch_name = "patch_id",
  coords = c("Pos_X", "Pos_Y"),
  convex = FALSE
)
}
\arguments{
\item{object}{a \code{SingleCellExperiment} or \code{SpatialExperiment}
object}

\item{patch_name}{single character indicating the \code{colData(object)} entry
containing the patch cell identifiers.}

\item{coords}{character vector of length 2 specifying the names of the
\code{colData} (for a \code{SingleCellExperiment} object) or the
\code{spatialCoords} entries of the cells' x and y locations.}

\item{convex}{should the convex hull be computed to construct the polygon?
Default: the concave hull is computed.}
}
\value{
A DataFrame object containing the patch identifier, the constructed
polygon and the polygon size.
}
\description{
This function constructs polygons around patch cells and
computes their area.
}
\examples{
library(cytomapper)
data(pancreasSCE)

# Build interaction graph
pancreasSCE <- buildSpatialGraph(pancreasSCE, img_id = "ImageNb", 
                                 type = "expansion", threshold = 20)

# Detect patches of "celltype_B" cells
pancreasSCE <- patchDetection(pancreasSCE, 
                              patch_cells = pancreasSCE$CellType == "celltype_B",
                              expand_by = 5, img_id = "ImageNb",
                              colPairName = "expansion_interaction_graph")
                              
# Compute the patch area
patchSize(pancreasSCE)
  
}
\author{
Nils Eling (\email{nils.eling@dqbm.uzh.ch})
}
