% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binAcrossPixels.R
\name{binAcrossPixels}
\alias{binAcrossPixels}
\title{Aggregate consecutive pixels per single-metal spot}
\usage{
binAcrossPixels(
  object,
  bin_size,
  spot_id = "sample_id",
  assay_type = "counts",
  statistic = "sum",
  ...
)
}
\arguments{
\item{object}{a \code{SingleCellExperiment} object containing pixel
intensities for all channels. Individual pixels are stored as columns and
channels are stored as rows.}

\item{bin_size}{single numeric indicating how many consecutive pixels per
spot should be aggregated.}

\item{spot_id}{character string indicating which \code{colData(object)} entry
stores the isotope names of the spotted metal.}

\item{assay_type}{character string indicating which assay to use.}

\item{statistic}{character string indicating the statistic to use for
aggregating consecutive pixels.}

\item{...}{additional arguments passed to \code{aggregateAcrossCells}}
}
\value{
returns the binned pixel intensities in form of a 
\code{SingleCellExperiment} object
}
\description{
Helper function for estimating the spillover matrix. Per metal 
spot, consecutive pixels a aggregated (default: summed).
}
\examples{
path <- system.file("extdata/spillover", package = "imcRtools")
# Read in .txt files
sce <- readSCEfromTXT(path)
dim(sce)

# Visualizes heatmap before aggregation
plotSpotHeatmap(sce)

# Sum consecutive pixels
sce <- binAcrossPixels(sce, bin_size = 10)
dim(sce)

# Visualizes heatmap after aggregation
plotSpotHeatmap(sce)

}
\seealso{
\code{\link[scuttle]{aggregateAcrossCells}} for the aggregation
function
}
\author{
Nils Eling (\email{nils.eling@dqbm.uzh.ch})
}
