% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaledHydropathy.R
\name{scaledHydropathyGlobal}
\alias{scaledHydropathyGlobal}
\title{Protein Scaled Hydropathy Calculations}
\usage{
scaledHydropathyGlobal(sequence, plotResults = FALSE, proteinName = NA, ...)
}
\arguments{
\item{sequence}{amino acid sequence as a single character string,
a vector of single characters, or an AAString object.
It also supports a single character string that specifies
the path to a .fasta or .fa file.}

\item{plotResults}{logical value, FALSE by default.
If \code{plotResults = TRUE} a plot will be the output.
If \code{plotResults = FALSE} the output is a data frame for each residue.}

\item{proteinName}{character string with length = 1.
optional setting to include the name in the plot title.}

\item{...}{any additional parameters, especially those for plotting.}
}
\value{
if \code{plotResults = TRUE}, a graphical representation data.
  Average is shown by the horizontal line.
  If \code{plotResults = FALSE}, a data frame is reported
  with each amino acid and each residue value shown.
  Score for each residue shown in the column "Hydropathy".
}
\description{
This is used to calculate the scaled hydropathy of an amino acid
  sequence for each residue in the sequence.
  The output is either a data frame or graph
  showing the matched scores for each residue along the sequence.
}
\section{Plot Colors}{

  For users who wish to keep a common aesthetic, the following colors are
  used when plotResults = TRUE. \cr
  \itemize{
  \item Dynamic line colors: \itemize{
  \item Close to 0 = "skyblue3" or "#6CA6CD"
  \item Close to 1 = "chocolate1" or "#FF7F24"
  \item Close to midpoint = "grey65" or "#A6A6A6"}}
}

\examples{
#Amino acid sequences can be character strings
aaString <- "ACDEFGHIKLMNPQRSTVWY"
#Amino acid sequences can also be character vectors
aaVector <- c("A", "C", "D", "E", "F",
              "G", "H", "I", "K", "L",
              "M", "N", "P", "Q", "R",
              "S", "T", "V", "W", "Y")
#Alternatively, .fasta files can also be used by providing
##The path to the file as a character string

exampleDF <- scaledHydropathyGlobal(aaString,
                                    plotResults = FALSE)
head(exampleDF)

exampleDF <- scaledHydropathyGlobal(aaVector,
                                    plotResults = FALSE)
head(exampleDF)

#plotResults = TRUE will output a ggplot
  scaledHydropathyGlobal(aaString,
                         plotResults = TRUE)

  #since it is a ggplot, you can change or annotate the plot
  gg <- scaledHydropathyGlobal(aaVector,
                               plotResults = TRUE)
  gg <- gg + ggplot2::ylab("Local Hydropathy")
  gg <- gg + ggplot2::geom_text(data = exampleDF,
                                ggplot2::aes(label = AA,
                                             y = Hydropathy + 0.1))
  plot(gg)
}
\references{
Kyte, J., & Doolittle, R. F. (1982). A simple method for
  displaying the hydropathic character of a protein.
  Journal of molecular biology, 157(1), 105-132.
}
\seealso{
\code{\link{KDNorm}} for residue values.

Other scaled hydropathy functions: 
\code{\link{KDNorm}},
\code{\link{foldIndexR}()},
\code{\link{meanScaledHydropathy}()},
\code{\link{scaledHydropathyLocal}()}
}
\concept{scaled hydropathy functions}
