% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ma.R
\name{plot_ma}
\alias{plot_ma}
\title{MA-plot from base means and log fold changes}
\usage{
plot_ma(
  res_obj,
  FDR = 0.05,
  point_alpha = 0.2,
  sig_color = "red",
  annotation_obj = NULL,
  draw_y0 = TRUE,
  hlines = NULL,
  title = NULL,
  xlab = "mean of normalized counts - log10 scale",
  ylim = NULL,
  add_rug = TRUE,
  intgenes = NULL,
  intgenes_color = "steelblue",
  labels_intgenes = TRUE,
  labels_repel = TRUE
)
}
\arguments{
\item{res_obj}{A \code{\link[DESeq2:DESeqResults]{DESeq2::DESeqResults()}} object}

\item{FDR}{Numeric value, the significance level for thresholding adjusted p-values}

\item{point_alpha}{Alpha transparency value for the points (0 = transparent, 1 = opaque)}

\item{sig_color}{Color to use to mark differentially expressed genes. Defaults to red}

\item{annotation_obj}{A \code{data.frame} object, with row.names as gene
identifiers (e.g. ENSEMBL ids) and a column, \code{gene_name}, containing
e.g. HGNC-based gene symbols. Optional}

\item{draw_y0}{Logical, whether to draw the horizontal line at y=0. Defaults to
TRUE.}

\item{hlines}{The y coordinate (in absolute value) where to draw horizontal lines,
optional}

\item{title}{A title for the plot, optional}

\item{xlab}{X axis label, defaults to "mean of normalized counts - log10 scale"}

\item{ylim}{Vector of two numeric values, Y axis limits to restrict the view}

\item{add_rug}{Logical, whether to add rug plots in the margins}

\item{intgenes}{Vector of genes of interest. Gene symbols if a \code{symbol}
column is provided in \code{res_obj}, or else the identifiers specified in the
row names}

\item{intgenes_color}{The color to use to mark the genes on the main plot.}

\item{labels_intgenes}{Logical, whether to add the gene identifiers/names close
to the marked plots}

\item{labels_repel}{Logical, whether to use \code{geom_text_repel} for placing the
labels on the features to mark}
}
\value{
An object created by \code{ggplot}
}
\description{
MA-plot from base means and log fold changes, in the ggplot2 framework, with
additional support to annotate genes if provided.
}
\details{
The genes of interest are to be provided as gene symbols if a \code{symbol}
column is provided in \code{res_obj}, or else by using  the identifiers specified
in the row names
}
\examples{
library("airway")
data("airway", package = "airway")
airway
dds_airway <- DESeq2::DESeqDataSetFromMatrix(assay(airway),
  colData = colData(airway),
  design = ~ cell + dex
)
# subsetting for quicker run, ignore the next two commands if regularly using the function
gene_subset <- c(
  "ENSG00000103196", # CRISPLD2
  "ENSG00000120129", # DUSP1
  "ENSG00000163884", # KLF15
  "ENSG00000179094", # PER1
  rownames(dds_airway)[rep(c(rep(FALSE, 99), TRUE), length.out = nrow(dds_airway))]
) # 1\% of ids
dds_airway <- dds_airway[gene_subset, ]

dds_airway <- DESeq2::DESeq(dds_airway)
res_airway <- DESeq2::results(dds_airway)

plot_ma(res_airway, FDR = 0.05, hlines = 1)

plot_ma(res_airway,
  FDR = 0.1,
  intgenes = c(
    "ENSG00000103196", # CRISPLD2
    "ENSG00000120129", # DUSP1
    "ENSG00000163884", # KLF15
    "ENSG00000179094"  # PER1
  ) 
)
}
