% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/res2tbl.R
\name{deseqresult2DEgenes}
\alias{deseqresult2DEgenes}
\title{Generate a tidy table with the DE genes from the results of DESeq}
\usage{
deseqresult2DEgenes(deseqresult, FDR = 0.05)
}
\arguments{
\item{deseqresult}{A \code{\link[DESeq2:DESeqResults]{DESeq2::DESeqResults()}} object}

\item{FDR}{Numeric value, the significance level for thresholding adjusted p-values}
}
\value{
A "tidy" data.frame with only genes marked as differentially expressed
}
\description{
Generate a tidy table with the DE genes from the results of DESeq
}
\examples{

# with simulated data...
library(DESeq2)
dds <- DESeq2::makeExampleDESeqDataSet(n = 100, m = 8, betaSD = 2)
dds <- DESeq(dds)
res <- results(dds)
deseqresult2DEgenes(res)
}
