% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitBAM_byIndex.R
\name{splitBAM_byIndex}
\alias{splitBAM_byIndex}
\title{Split the composite BAM file using internal indexes (MAPCap)}
\usage{
splitBAM_byIndex(
  bamFile,
  index_list,
  outfile_list,
  max_mismatch = 0,
  ncores = 1
)
}
\arguments{
\item{bamFile}{character. Path to a mapped BAM file}

\item{index_list}{character. A list of indexes for splitting}

\item{outfile_list}{character. A list of output file names (with order corresponding to that of index_list)}

\item{max_mismatch}{integer. No. of mismatches allowed in index (maxium 1 recommended)}

\item{ncores}{integer. Number of cores to use for parallel processing}
}
\value{
Filtered files
}
\description{
Split the composite BAM file using internal indexes (MAPCap)
}
\examples{

bam <- system.file("extdata", "bam/embryo1.bam", package = "icetea")
splitBAM_byIndex(bamFile = bam,
                 index_list = c("CAAGTG", "CAAGTT"),
                 outfile_list = c("test_filt1.bam","test_filt2.bam"),
                 ncores = 1)

}
