% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/detectTSS.R
\name{exportTSS}
\alias{exportTSS}
\alias{exportTSS,CapSet-method}
\title{Export the detected TSS from CapSet object as .bed files}
\usage{
exportTSS(CSobject, outfile_prefix, pergroup = FALSE, merged = TRUE)

\S4method{exportTSS}{CapSet}(CSobject, outfile_prefix, pergroup = FALSE, merged = TRUE)
}
\arguments{
\item{CSobject}{The modified CapSet object after running \code{\link{detectTSS}} function}

\item{outfile_prefix}{Prefix (with path) for output .bed files}

\item{pergroup}{If TRUE, write output per group of samples}

\item{merged}{If TRUE, write merged bed file (union of all groups)}
}
\value{
.bed file(s) containing detected TSS.
}
\description{
Export the detected TSS from CapSet object as .bed files
}
\examples{
# load a previously saved CapSet object
cs <- exampleCSobject()
# export tss
exportTSS(cs, merged = TRUE, outfile_prefix = "testTSS")

}
