% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/demultiplexFASTQ.R
\name{demultiplexFASTQ}
\alias{demultiplexFASTQ}
\alias{demultiplexFASTQ,CapSet-method}
\title{Demultiplex and tag fastq files using sample barcodes}
\usage{
demultiplexFASTQ(CSobject, outdir, max_mismatch = 0, ncores = 1)

\S4method{demultiplexFASTQ}{CapSet}(CSobject, outdir, max_mismatch = 0, ncores = 1)
}
\arguments{
\item{CSobject}{CapSet object created using \code{\link{newCapSet}} function}

\item{outdir}{character. path to output directory}

\item{max_mismatch}{integer. maximum allowed mismatches in the sample barcode}

\item{ncores}{integrer. No. of cores/threads to use}
}
\value{
de-multiplxed fastq files corresponding to each barcode. The files are written
        on disk with the corresponding sample names as specified in the CapSet object
}
\description{
Demultiplex and tag fastq files using sample barcodes
}
\examples{
# load a previously saved CapSet object
cs <- exampleCSobject()

# demultiplex allowing one mismatch in sample indexes
dir.create("demult_fastq")
cs <- demultiplexFASTQ(cs, outdir =  "demult_fastq", max_mismatch = 1)

}
