% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_geneset.R
\name{utils-geneset}
\alias{utils-geneset}
\alias{.getIdentifierType}
\alias{.setIdentifierType}
\alias{.getOrganism}
\alias{.setOrganism}
\alias{.getGeneSetCommands}
\alias{.setGeneSetCommands}
\title{Gene set utilities}
\usage{
.getIdentifierType()

.setIdentifierType(value)

.getOrganism()

.setOrganism(value)

.getGeneSetCommands(collection, mode)

.setGeneSetCommands(value)
}
\arguments{
\item{value}{For \code{.setIdentifierType} and \code{.setOrganism},
a string containing the type of identifier or organism package to use.

For \code{.setGeneSetCommands}, a named list containing two character vectors, see Details.}

\item{collection}{String specifying the gene set collection.}

\item{mode}{String specifying the mode of operation for the returned commands.}
}
\value{
\code{.getIdentifierType} will return the identifier type to use, defaulting to \code{"ENTREZID"}.

\code{.getOrganism} will return the organism package to use, defaulting \code{"org.Hs.eg.db"}.

\code{.getGeneSetCommands} will return:
\itemize{
\item If \code{mode="show"}, a string containing R commands that create \code{tab},
a data.frame of all gene sets for a given \code{collection}.
\item If \code{mode="extract"}, a format string containing R commands that (after formatting) create \code{selected},
a character vector of gene identities for the selected gene set.
This format string should accept one string argument corresponding to the deparsed name of the gene set.
}

Each of the setter functions will set the corresponding option and return \code{NULL}, invisibly.
}
\description{
Utility functions to control the behavior of the \linkS4class{GeneSetTable}.
}
\details{
By default, \code{.getGeneSetCommands} will extract GO and KEGG terms.
The organism and identifier type relates to the manner in which this default extraction is performed.

Users can add their own gene set collections by supplying a named list to \code{.setGeneSetCommands}.
Each element of the list should be a named character vector of length two,
with names \code{"show"} and \code{"extract"} - see the return value for what these are.
The names of the list should be unique and will be used in the \linkS4class{GeneSetTable} interface.

Alternatively, any element of the list may be \code{NULL}, in which case it is excluded from the interface.
This is useful for setting, e.g., \code{GO=NULL} to ignore the in-built GO terms.
}
\examples{
.setIdentifierType("ENSEMBLID")
.getIdentifierType()

.setOrganism("org.Mm.eg.db")
.getOrganism()

.getGeneSetCommands("GO", "show")
.getGeneSetCommands("GO", "extract")

.setGeneSetCommands(
    list(AaronRandomCollection=
        c(
            show='tab <- some_function_to_list_my_gene_sets()',
            extract='selected <- some_function_to_get_one_gene_set(\%s)'
        )
    )
)

.getGeneSetCommands("AaronRandomCollection", "show")
.getGeneSetCommands("AaronRandomCollection", "extract")

}
\seealso{
\linkS4class{GeneSetTable}, where these functions have their effect.
}
\author{
Aaron Lun
}
