% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/class-ColumnGraphPlot.R
\docType{class}
\name{ColumnGraphPlot-class}
\alias{ColumnGraphPlot-class}
\alias{ColumnGraphPlot}
\title{Column graph plot}
\value{
The \code{ColumnGraphPlot(...)} constructor creates an instance of a
ColumnGraphPlot class, where any slot and its value can be passed to
\code{...} as a named argument.
}
\description{
Network organisation for the samples of a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object. The igraph should be stored in the \code{metadata} slot by a name
containing \code{"graph"}. This panel uses
\code{\link[miaViz:plotColGraph]{plotColGraph}}
to generate the plot.
}
\section{Slot overview}{


This class inherits all slots from its parent class \linkS4class{GraphPlot}.
}

\examples{
library(mia)
library(miaViz)
data("GlobalPatterns", library = "mia")
data("col_graph", library = "miaViz")

tse <- GlobalPatterns
tse <- agglomerateByRank(tse,
                         rank = "Genus",
                         na.rm = TRUE)
                         
metadata(tse)$graph <- col_graph

# Store panel into object
panel <- ColumnGraphPlot()
# View some adjustable parameters
head(slotNames(panel))

# Launch iSEE with custom initial panel
if (interactive()) {
  iSEE(tse, initial = c(panel))
}

}
\seealso{
\linkS4class{GraphPlot}
\linkS4class{RowGraphPlot}
}
\author{
Giulio Benedetti
}
