% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReducedDimensionHexPlot.R
\docType{methods}
\name{ReducedDimensionHexPlot-class}
\alias{ReducedDimensionHexPlot-class}
\alias{ReducedDimensionHexPlot}
\alias{initialize,ReducedDimensionHexPlot-method}
\alias{.fullName,ReducedDimensionHexPlot-method}
\alias{.panelColor,ReducedDimensionHexPlot-method}
\alias{.createObservers,ReducedDimensionHexPlot-method}
\alias{.hideInterface,ReducedDimensionHexPlot-method}
\alias{.defineVisualShapeInterface,ReducedDimensionHexPlot-method}
\alias{.defineVisualSizeInterface,ReducedDimensionHexPlot-method}
\alias{.defineVisualOtherInterface,ReducedDimensionHexPlot-method}
\alias{.generateDotPlot,ReducedDimensionHexPlot-method}
\alias{.definePanelTour,ReducedDimensionHexPlot-method}
\alias{.getDotPlotColorHelp,ReducedDimensionHexPlot-method}
\alias{.allowableColorByDataChoices,ReducedDimensionHexPlot-method}
\title{The ReducedDimensionHexPlot class}
\description{
The ReducedDimensionHexPlot is a \linkS4class{ReducedDimensionPlot} subclass that is dedicated to creating a reduced dimension plot summarising data points in hexagonal bins.
}
\section{Slot overview}{

The following slots control the parameters used in the visualization:
\itemize{
\item \code{BinResolution}, a numeric positive scalar specifying the number of hexagonal bins in both vertical and horizontal directions.
Defaults to 100.
}

In addition, this class inherits all slots from its parent \linkS4class{ReducedDimensionPlot},
\linkS4class{ColumnDotPlot}, \linkS4class{DotPlot} and \linkS4class{Panel} classes.
}

\section{Constructor}{

\code{ReducedDimensionHexPlot(...)} creates an instance of a ReducedDimensionHexPlot class,
where any slot and its value can be passed to \code{...} as a named argument.
}

\section{Supported methods}{

In the following code snippets, \code{x} is an instance of a \linkS4class{ReducedDimensionHexPlot} class.
Refer to the documentation for each method for more details on the remaining arguments.

For defining the interface:
\itemize{
\item \code{\link{.panelColor}(x)} will return the specified default color for this panel class.
\item \code{\link{.fullName}(x)} will return \code{"Hexagonal reduced dimension plot"}.
\item \code{\link{.hideInterface}(x, field)} will return \code{TRUE} for \code{field="Downsample"} as downsampling is not applicable to this panel that summarizes all data points in each hexagonal bin;
otherwise this function will call the \linkS4class{ReducedDimensionPlot} method.
\item \code{\link{.defineVisualShapeInterface}(x)} will return \code{NULL} for this panel, as the shape aesthetic is not applicable to this panel that does not display individual data points.
\item \code{\link{.defineVisualSizeInterface}(x)} overrides the equivalent method inherited from all parents classes and will return instead an HTML tag definition that contains a user input controlling the number of hexagonal bins in both vertical and horizontal directions.
\item \code{\link{.defineVisualOtherInterface}(x)} will return \code{NULL}, as there are no additional visual parameters for this panel.
\item \code{\link{.allowableColorByDataChoices}(x, se)} will return a character vector with the names of all continuous fields in \code{\link[SummarizedExperiment:colData]{colData(se)}},
where \code{se} is the input \linkS4class{SummarizedExperiment} object.
}

For monitoring reactive expressions:
\itemize{
\item \code{\link{.createObservers}(x, se, input, session, pObjects, rObjects)} sets up observers for all new slots described above, as well as in the parent classes via the \linkS4class{ReducedDimensionPlot} method.
}

For creating the plot:
\itemize{
\item \code{\link{.generateDotPlot}(x, envir)} will return a list with \code{plot}, a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object; and \code{commands}, a character vector of commands to produce that object when evaluated inside \code{envir}.
}

For documentation:
\itemize{
\item \code{\link{.definePanelTour}(x)} returns an data.frame containing the steps of a panel-specific tour.
\item \code{\link{.getDotPlotColorHelp}(x, color_choices)} returns a function that generates an \pkg{rintrojs} tour for the color choice UI.
}
}

\examples{
library(scRNAseq)

# Example data ----
sce <- ReprocessedAllenData(assays="tophat_counts")
class(sce)

library(scater)
sce <- logNormCounts(sce, exprs_values="tophat_counts")

sce <- runPCA(sce, ncomponents=4)
sce <- runTSNE(sce)
rowData(sce)$ave_count <- rowMeans(assay(sce, "tophat_counts"))
rowData(sce)$n_cells <- rowSums(assay(sce, "tophat_counts") > 0)

# launch the app itself ----

if (interactive()) {
    iSEE(sce, initial=list(
        ReducedDimensionHexPlot(BinResolution=50),
        ReducedDimensionPlot()
    ))
}

}
\seealso{
\link{ReducedDimensionPlot}, for the base class.
}
\author{
Kevin Rue-Albrecht
}
