% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family_RowTable.R
\docType{methods}
\name{RowTable-class}
\alias{RowTable-class}
\alias{initialize,RowTable-method}
\alias{.refineParameters,RowTable-method}
\alias{.defineInterface,RowTable-method}
\alias{.createObservers,RowTable-method}
\alias{.hideInterface,RowTable-method}
\alias{.multiSelectionDimension,RowTable-method}
\alias{.multiSelectionResponsive,RowTable-method}
\alias{.singleSelectionDimension,RowTable-method}
\alias{.showSelectionDetails,RowTable-method}
\title{The RowTable class}
\description{
The RowTable is a virtual class where each row in the \linkS4class{SummarizedExperiment} is represented by no more than one row in a \code{\link{datatable}} widget.
In panels of this class, single and multiple selections can only be transmitted on the features.
}
\section{Slot overview}{

No new slots are added.
All slots provided in the \linkS4class{Table} parent class are available.
}

\section{Supported methods}{

In the following code snippets, \code{x} is an instance of a \linkS4class{RowTable} class.
Refer to the documentation for each method for more details on the remaining arguments.

For setting up data values:
\itemize{
\item \code{\link{.refineParameters}(x, se)} replaces \code{NA} values in \code{Selected} with the first row name of \code{se}.
This will also call the equivalent \linkS4class{Table} method.
}

For defining the interface:
\itemize{
\item \code{\link{.hideInterface}(x, field)} returns a logical scalar indicating whether the interface element corresponding to \code{field} should be hidden.
This returns \code{TRUE} for column selection parameters (\code{"ColumnSelectionSource"} and \code{"ColumnSelectionRestrict"}),
otherwise it dispatches to the \linkS4class{Panel} method.
}

For monitoring reactive expressions:
\itemize{
\item \code{\link{.createObservers}(x, se, input, session, pObjects, rObjects)} sets up observers to propagate changes in the \code{Selected} to linked plots.
This will also call the equivalent \linkS4class{Table} method.
}

For controlling selections:
\itemize{
\item \code{\link{.multiSelectionDimension}(x)} returns \code{"row"} to indicate that a row selection is being transmitted.
\item \code{\link{.singleSelectionDimension}(x)} returns \code{"feature"} to indicate that a feature identity is being transmitted.
}

For rendering output:
\itemize{
\item \code{\link{.showSelectionDetails}(x)} returns a HTML element containing details about the selected row.
This requires a function to be registered by \code{\link{registerAppOptions}} under the option name \code{"RowTable.select.details"}.
The function should take a string containing the name of a feature (i.e., the current selection in the \linkS4class{RowTable}) and returns a HTML element.
If no function is registered, \code{NULL} is returned.
}

Unless explicitly specialized above, all methods from the parent classes \linkS4class{DotPlot} and \linkS4class{Panel} are also available.
}

\section{Subclass expectations}{

Subclasses are expected to implement methods for:
\itemize{
\item \code{\link{.generateTable}}
\item \code{\link{.fullName}}
\item \code{\link{.panelColor}}
}

The method for \code{\link{.generateTable}} should create a \code{tab} data.frame where each row corresponds to a row in the \linkS4class{SummarizedExperiment} object.
}

\seealso{
\linkS4class{Table}, for the immediate parent class that contains the actual slot definitions.
}
\author{
Aaron Lun
}
