% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/direct_gene_cna.R
\name{direct_gene_cna}
\alias{direct_gene_cna}
\title{Load the existed CNA gain/loss based on gene location.}
\usage{
direct_gene_cna(sample_desc, gain_threshold = log2(2.5) - 1,
  loss_threshold = log2(1.5) - 1, read_fun = NULL, progress = TRUE,
  progress_width = 48, parallel = FALSE, ...)
}
\arguments{
\item{sample_desc}{\link[data.table]{data.table} object created by
\link{create_sample_desc}.}

\item{gain_threshold}{CNA expression above this will be considered as gain
region. By default \eqn{\log_2{2.5} - 1}}

\item{loss_threshold}{CNA expression below this will be considered as loss
region. By default \eqn{\log_2{1.5} - 1}}

\item{read_fun}{Custom reader function, see its own section for more detail.}

\item{progress}{Whether to display a progress bar. By default \code{TRUE}.}

\item{progress_width}{The text width of the shown progress bar. By default is
48 chars wide.}

\item{parallel}{Enable parallelism by plyr. One has to specify a parallel
engine beforehand. See example for more information.}

\item{...}{Arguments passed to the custom reader function specified in
  \code{read_fun}.}
}
\value{
data.table of CNA gain/loss on each gene region for all samples,
  whose rows represent regions of genes and columns are sample names. First
  column \code{GENE} contains the corresponding gene names.
}
\description{
This function aims to complement \code{\link{create_gene_cna}}. Instead of
mapping CNA records onto genes by genome reference, it reads the existed
column containing the gene each CNA lies on. Two functions share the same
interface but they have different requirement for the \code{read_fun}
implementation.
}
\section{Custom reader function}{
 Similar to that of \link{create_gene_cna},
  the reader function takes the filepath as the first argument. It will
  return a data.table with at least two columns: \code{GENE} and
  \code{Segment_Mean} of type \code{character} and \code{numeric}
  respectively.
}
\examples{
require(data.table)

## Create a CNA dataset that has been already mapped onto gene regions

cna_geo_list = list(
    sample_A = data.table(
        GENE = c("TP53", "BRCA2"),
        Segment_Mean = c(1.05, -2.03)
    ),
    sample_B = data.table(
        GENE = c("TP53", "BRCA2", "NDPH1"),
        Segment_Mean = c(0.38, -1.71, 2.6)
    )
)
sample_desc <- data.table(
    Sample = paste("sample", c("A", "B"), sep = "_")
)
sample_desc$CNA_filepath <- sample_desc$Sample


## Example code for reading

read_cna_geo <- function(pth) {
    # For demonstration, file reading silently redirects
    # to list lookup
    cna_geo_list[[pth]]
}
gene_cna <- direct_gene_cna(
    sample_desc,
    read_fun = read_cna_geo, progress = FALSE
)
gene_cna
}
\seealso{
\code{\link{create_gene_cna}}
}

