% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_methods.R
\name{plot_overlap}
\alias{plot_overlap}
\title{Plot Venn diagram}
\usage{
plot_overlap(cobraplot, ...)
}
\arguments{
\item{cobraplot}{A \code{COBRAPlot} object.}

\item{...}{Additional arguments to \code{limma::vennDiagram}.}
}
\value{
Nothing, displays a graph
}
\description{
Plot a Venn diagram showing the overlaps among sets of significant feature
for a given adjusted p-value threshold (see \code{thr_venn} argument of
\code{calculate_performance}). Optionally, the truth can be included
as a "perfect" method. Note that maximally five methods (including the truth,
if applicable) can be compared.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example,
                                   binary_truth = "status",
                                   aspects = "overlap")
cobraplot <- prepare_data_for_plot(cobraperf, colorscheme = "Dark2",
                                   incltruth = TRUE)
plot_overlap(cobraplot)
}
\author{
Charlotte Soneson
}
