% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vennCount.R
\name{vennCount}
\alias{vennCount}
\title{Construct intersections of sets}
\usage{
vennCount(gi, FUN = min, ...)
}
\arguments{
\item{gi}{A vector of bedpe files or a list of genomic interaction data
(\link[S4Vectors:Pairs-class]{Pairs} or
\link[InteractionSet:GInteractions-class]{GInteractions})}

\item{FUN}{Function to summarize the overlapping number.}

\item{\dots}{parameters used by
\link[InteractionSet:findOverlaps]{findOverlaps}}
}
\value{
An object of \link{vennTable}
}
\description{
Given a collection of bedpe files or a list of genomic interaction data,
\code{vennCount} will compute all possible combinations of interactions
and return an object of class \link{vennTable}, storing the combinations
as well as the number of elements in each intersection.
}
\examples{
pd <- system.file("extdata", package = "hicVennDiagram", mustWork = TRUE)
fs <- dir(pd, pattern = ".bedpe", full.names = TRUE)
vc <- vennCount(fs)

}
