% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_cor_samplevar.R
\docType{class}
\name{correlate,HermesDataPca-method}
\alias{correlate,HermesDataPca-method}
\alias{pca_cor_samplevar}
\alias{HermesDataPcaCor-class}
\alias{.HermesDataPcaCor}
\alias{HermesDataPcaCor}
\alias{autoplot,HermesDataPcaCor-method}
\title{Correlation of Principal Components with Sample Variables}
\usage{
\S4method{correlate}{HermesDataPca}(object, data)

\S4method{autoplot}{HermesDataPcaCor}(
  object,
  cor_colors = circlize::colorRamp2(c(-1, 0, 1), c("blue", "white", "red")),
  ...
)
}
\arguments{
\item{object}{(\code{HermesDataPca})\cr input. It can be generated using \code{\link[=calc_pca]{calc_pca()}} function
on \code{\link{AnyHermesData}}.}

\item{data}{(\code{AnyHermesData})\cr input that was used originally for the PCA.}

\item{cor_colors}{(\code{function})\cr color scale function for the correlation values in the heatmap,
produced by \code{\link[circlize:colorRamp2]{circlize::colorRamp2()}}.}

\item{...}{other arguments to be passed to \code{\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap()}}.}
}
\value{
A \code{\link{HermesDataPcaCor}} object with R2 values for all sample variables.
}
\description{
This \code{correlate()} method analyses the correlations (in R2 values) between all sample variables
in a \code{\link{AnyHermesData}} object and the principal components of the samples.

A corresponding \code{autoplot()} method then can visualize the results in a heatmap.
}
\section{Functions}{
\itemize{
\item \code{autoplot(HermesDataPcaCor)}: This plot method uses the \code{\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap()}} function
to visualize a \code{\link{HermesDataPcaCor}} object.

}}
\examples{
object <- hermes_data \%>\%
  add_quality_flags() \%>\%
  filter() \%>\%
  normalize()

# Perform PCA and then correlate the prinicipal components with the sample variables.
object_pca <- calc_pca(object)
result <- correlate(object_pca, object)

# Visualize the correlations in a heatmap.
autoplot(result)

# We can also choose to not reorder the columns.
autoplot(result, cluster_columns = FALSE)

# We can also choose break-points for color customization.
autoplot(
  result,
  cor_colors = circlize::colorRamp2(
    c(-0.5, -0.25, 0, 0.25, 0.5, 0.75, 1),
    c("blue", "green", "purple", "yellow", "orange", "red", "brown")
  )
)
}
\seealso{
\code{\link[=h_pca_df_r2_matrix]{h_pca_df_r2_matrix()}} which is used internally for the details.
}
