% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_cdisc.R
\name{inner_join_cdisc}
\alias{inner_join_cdisc}
\title{Inner Joining a Genes with a CDISC Data Set}
\usage{
inner_join_cdisc(
  gene_data,
  cdisc_data,
  patient_key = "USUBJID",
  additional_keys = character()
)
}
\arguments{
\item{gene_data}{(\code{data.frame} or \code{DataFrame})\cr genetic data.}

\item{cdisc_data}{(\code{data.frame})\cr CDISC data (typically patient level data).}

\item{patient_key}{(\code{string})\cr patient identifier.}

\item{additional_keys}{(\code{character})\cr potential additional keys for the two data sets.}
}
\value{
A \code{data.frame} which contains columns from both data sets merged by the keys.
}
\description{
This is a useful function when trying to join genetic with CDISC data sets.
}
\note{
Columns which are contained in both data sets but are not specified as keys are taken
from \code{gene_data} and not from \code{cdisc_data}.
}
\examples{
gene_data <- col_data_with_genes(hermes_data, "counts", gene_spec("GeneID:1820"))
cdisc_data <- data.frame(
  USUBJID = head(gene_data$USUBJID, 10),
  extra = 1:10
)
result <- inner_join_cdisc(gene_data, cdisc_data)
result
}
