% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connections.R
\name{h_get_annotation_biomart}
\alias{h_get_annotation_biomart}
\title{Get Annotations from \code{BioMart}}
\usage{
h_get_annotation_biomart(gene_ids, id_var, mart)
}
\arguments{
\item{gene_ids}{(\code{character})\cr gene IDs, e.g. \code{10329}, i.e. already
without the \code{Entrez} \code{GeneID} prefix, or \code{ENSG00000241644} for \code{Ensembl} gene ID.}

\item{id_var}{(\code{string})\cr corresponding gene ID variable name in \code{BioMart},
i.e. \code{entrezgene_id} or \code{ensembl_gene_id}.}

\item{mart}{(\code{Mart})\cr given \code{\link[biomaRt:Mart-class]{biomaRt::Mart}} object.}
}
\value{
A data frame with columns:
\itemize{
\item \code{id_var} (depending on what was used)
\item \code{hgnc_symbol}
\item \code{entrezgene_description}
\item \code{chromosome_name}
\item \code{size}
\item \code{refseq_mrna}
\item \code{refseq_peptide}
}
}
\description{
Helper function to query annotations from \code{biomaRt}, for cleaned up gene IDs of
a specific ID variable and given \code{\link[biomaRt:Mart-class]{biomaRt::Mart}}.
}
\examples{
if (interactive()) {
  mart <- biomaRt::useMart("ensembl", dataset = "hsapiens_gene_ensembl")
  h_get_annotation_biomart(c("11185", "10677"), id_var = "entrezgene_id", mart = mart)
}
}
