% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PWMScanHeatmap.R
\docType{methods}
\name{PWMScanHeatmap}
\alias{PWMScanHeatmap}
\alias{PWMScanHeatmap,DNAStringSet,matrix-method}
\title{Generate a Heatmap of PWM Scores in DNA sequnce}
\usage{
PWMScanHeatmap(seq, pwm, ...)

\S4method{PWMScanHeatmap}{DNAStringSet,matrix}(seq, pwm, coords = NULL,
  label = "")
}
\arguments{
\item{seq}{A DNAString of equal length}

\item{pwm}{A PWM}

\item{...}{additional arguments used by methods

This function creates a heatmap where each point is the score of a PWM match
starting from that position, which can visualise regions of enrichment or exclusion
of certain motifs}

\item{coords}{Co-ordinates for the heatmap, defaults to c(0, width(windows))}

\item{label}{Label for the heatmap}
}
\value{
A heatmap
}
\description{
Generate a Heatmap of PWM Scores in DNA sequnce
}
\section{Methods (by class)}{
\itemize{
\item \code{seq = DNAStringSet,pwm = matrix}: Heatmap of PWM Scores
}}

\examples{
data(HeatmapExamples)
PatternHeatmap(string_set, tata_pwm, coords=c(-100, 100), label="TATA Scan")
}
\seealso{
PatternHeatmap
}
