% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdxmsqc-utils.R
\name{chargeCorrelationHdx}
\alias{chargeCorrelationHdx}
\title{Charge states should have correlated incorperation but they need not
be exactly the same}
\usage{
chargeCorrelationHdx(object, experiment = NULL, timepoints = NULL)
}
\arguments{
\item{object}{An object of class \code{QFeatures}}

\item{experiment}{A character vector indicating the experimental conditions}

\item{timepoints}{A numeric vector indicating the experimental timepoints}
}
\description{
Charge states should have correlated incorperation but they need not
be exactly the same
}
\examples{
data("BRD4df_full")
BRD4df_filtered <- isMissingAtRandom(object = BRD4df_full)
BRD4df_full_imputed <- impute(BRD4df_filtered, method = "zero", i = 1)
experiment <- c("wt", "iBET")
timepoints <- rep(c(0, 15, 60, 600, 3600, 14000), each = 3)
monoStat <- chargeCorrelationHdx(object = BRD4df_full_imputed,
experiment = experiment, 
timepoints = timepoints)
}
\author{
Oliver Crook
}
