\name{writeReference}
\alias{writeReference}

\title{Filling the Reference dataset in a tally file from a DNAString}

\description{ Function to fill the Reference dataset of a tally file from a DNAString object}
\usage{
writeReference( tallyFile, group, dnastring, blocksize = 1000000, verbose = TRUE )
}

\arguments{

  \item{tallyFile}{
    filename of a tally file matching the variant calls
  }

  \item{group}{
    The group that the \code{Reference} dataset is located in
  }
  
  \item{dnastring}{
    A \code{DNAString} object containing the new reference sequence
  }
  
  \item{blocksize}{
    The size of blocks in which to process the reference (higher values imply higher memory consumption)
  }
  
  \item{verbose}{
    Boolean flag to specify if diagnostic messages should be printed  
  }
}
\details{
  This function takes a tally file, a location within it (the \code{group} argument) and a reference sequence as a \code{DNAString} object, encodes the reference in the appropriate way and writes it to the location in the tally file in blocks of size specified in \code{blocksize}.
  The reference will be written to a dataset with the path \code{paste(group, "Reference", sep = "/")} within the tally file.
  The dataset itself must exists and have the correct dimensions to hold the sequence specified in \code{dnastring}.
}
\value{
  Returns \code{TRUE} on success.
}
\author{
Paul Pyl
}

\examples{
library(h5vc)
library(rhdf5)
library(Biostrings)
filename = file.path(tempdir(), "write.ref.test.hfs5")
prepareTallyFile(filename=filename,study="SomeStudy",chrom="Foo",chromlength=8,nsamples=1)
writeReference(filename, group = "/SomeStudy/Foo", dnastring = DNAString("GATTACCA"))
h5dump(filename)$SomeStudy$Foo$Reference
}
