\name{h5readBlock}
\alias{h5readBlock}

\title{h5readBlock}
\description{
A simple access function for extracting a single block of data from a tally file, use \code{\link{h5dapply}} for applying functions on multiple blocks / extracting multiple blocks form a tally file.
}
\usage{
h5readBlock( filename, group, names, dims, range, samples = NULL, sampleDimMap = .sampleDimMap, verbose = FALSE )
}
\arguments{
  \item{filename}{ The name of a tally file to process }
  \item{group}{The name of a group in that tally file }
  \item{names}{The names of the datasets to extract,
    e.g. \code{c("Counts","Coverages")} - optional (defaults to all datasets)}
  \item{dims}{The dimension in which the block shall be extracted for each dataset in the same
    order as \code{names}, these should correspond to compatible
    dimensions between the datsets. - optional (defaults to the genomic position dimension)}
  \item{range}{The range along the specified dimensions which should be
    extracted }
  \item{samples}{Character vector of sample names - must match contents of sampleData stored in the \code{tallyFile}}
  \item{sampleDimMap}{A list mapping dataset names to their respective sample dimensions - default provides values for "Counts", "Coverages", "Deletions" and "Reference"}
  \item{verbose}{Boolean flag that controls the amount of messages being
    printed by \code{h5dapply}}
}
\details{
This function extracts a block along the dimensions specified in \code{dims} (default: genomic position) from the datasets specified in \code{names} and returns it. The block is defined by the parameter \code{range}.

The function returns a \code{list} with one slot for each dataset specified in the \code{names} argument to containing the array corresponding to the specified block in the given dataset. Furthemore the slot \code{h5dapplyInfo} is reserved and contains another \code{list} with the following content:

\code{Blockstart} is an integer specifying the starting position of the current block (in the dimension specified by the \code{dims} argument to \code{h5dapply})

\code{Blockend} is an integer specifying the end position of the current block (in the dimension specified by the \code{dims} argument to \code{h5dapply})

\code{Datasets} Contains a \code{data.frame} as it is returned by \code{\link[rhdf5]{h5ls}} listing all datasets present in the other slots of \code{data} with their group, name, dimensions, number of dimensions (\code{DimCount}) and the dimension that is used for splitting into blocks (\code{PosDim})

\code{Group} contains the name of the group as specified by the \code{group} argument to \code{h5dapply}

}
\value{
A list with one entry per dataset and an additional slot \code{h5dapplyInfo} containing auxiliary information.
}
\author{
Paul Pyl
}

\examples{
library(h5vc) # loading the library
tallyFile <- system.file( "extdata", "example.tally.hfs5", package = "h5vcData" )
data <- h5readBlock( #extracting coverage, deletions and reference using h5dreadBlock
  filename = tallyFile,
  group = "/ExampleStudy/16",
  names = c( "Coverages", "Deletions", "Reference" ),
  range = c(29000000,29010000),
  verbose = TRUE
)
str(data)
sampleData <- getSampleData( tallyFile, "/ExampleStudy/16" )
#Subsetting by Sample
sampleData <- sampleData[sampleData$Patient == "Patient8",]
data <- h5readBlock( #extracting coverage, deletions and reference using h5dreadBlock
  filename = tallyFile,
  group = "/ExampleStudy/16",
  names = c( "Coverages", "Deletions", "Reference" ),
  range = c(29000000,29010000),
  samples = sampleData$Sample,
  verbose = TRUE
)
str(data)
}