% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updater.R
\name{makeCurrentGwascat}
\alias{makeCurrentGwascat}
\title{read NHGRI GWAS catalog table and construct associated GRanges instance
records for which clear genomic position cannot be determined are dropped
from the ranges instance
an effort is made to use reasonable data types for GRanges metadata, so some
qualifying characters such as (EA) in Risk allele frequency field will
simply be omitted during coercion of contents of that field to numeric.}
\usage{
makeCurrentGwascat(
  table.url =
    "https://www.ebi.ac.uk/gwas/api/search/downloads/associations/v1.0.2?split=false",
  fixNonASCII = FALSE,
  genome = "GRCh38",
  withOnt = TRUE
)
}
\arguments{
\item{table.url}{string identifying the .txt file curated at EBI/EMBL}

\item{fixNonASCII}{logical, if TRUE, non-ASCII characters as identified by
iconv will be replaced by asterisk; default is FALSE starting Dec 29 2025.}

\item{genome}{character string: 'GRCh38' is default and yields current image
as provided by EMBL/EBI; 'GRCh37' yields a realtime liftOver to hg19
coordinates, via AnnotationHub storage of the chain files. Any other value
yields an error.}

\item{withOnt}{logical indicating whether 'alternative' (ontology-present,
includes repetition of loci with one:many ontological mapping) or 'full'
(ontology-absent, one record per locus report) version of distributed table}
}
\value{
a slightly extended GRanges instance, with class name `gwaswloc`; the purpose
of the introduction of this class is to support a concise show method that does not
produce very long lines owing to large numbers of fields in the mcols component.
}
\description{
read NHGRI GWAS catalog table and construct associated GRanges instance
records for which clear genomic position cannot be determined are dropped
from the ranges instance
an effort is made to use reasonable data types for GRanges metadata, so some
qualifying characters such as (EA) in Risk allele frequency field will
simply be omitted during coercion of contents of that field to numeric.
}
\examples{

# if you have good internet access
  if (interactive()) {
     newcatr = makeCurrentGwascat()
     newcatr
     }

}
\author{
VJ Carey
}
\keyword{models}
