% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traitsManh.R
\name{traitsManh}
\alias{traitsManh}
\title{use ggbio facilities to display GWAS results for selected traits in genomic
coordinates}
\usage{
traitsManh(
  gwr,
  selr = GRanges(seqnames = "chr17", IRanges(3e+07, 5e+07)),
  traits = c("Asthma", "Parkinson's disease", "Height", "Crohn's disease"),
  truncmlp = 25,
  ...
)
}
\arguments{
\item{gwr}{GRanges instance as managed by the gwaswloc container design,
with Disease.Trait and Pvalue\_mlog among elementMetadata columns}

\item{selr}{A GRanges instance to restrict the \code{gwr} for visualization.
Not tested for noncontiguous regions.}

\item{traits}{Character vector of traits to be exhibited; GWAS results with
traits not among these will be labeled ``other''.}

\item{truncmlp}{Maximum value of -log10 p to be displayed; in the raw data
this ranges to the hundreds and can cause bad compression.}

\item{\dots}{not currently used}
}
\value{
autoplot value
}
\description{
use ggbio facilities to display GWAS results for selected traits in genomic
coordinates
}
\details{
uses a ggbio autoplot
}
\note{
An xlab is added, concatenating genome tag with seqnames tag.
}
\examples{

# do a p-value truncation if you want to reduce compression
\dontrun{  # ggbio July 2018
data(ebicat_2020_04_30)
library(GenomeInfoDb)
seqlevelsStyle(ebicat_2020_04_30) = "UCSC"
traitsManh(ebicat_2020_04_30)
 }

}
\author{
VJ Carey <stvjc@channing.harvard.edu>
}
\keyword{graphics}
\keyword{models}
