% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaGene.R
\name{metaGene}
\alias{metaGene}
\title{Returns a histogram of the number of reads in each section of a moving
window centered on a certain feature.}
\usage{
metaGene(
  features,
  reads = NULL,
  plusCVG = NULL,
  minusCVG = NULL,
  size = 100L,
  up = 10000L,
  down = NULL,
  ...
)
}
\arguments{
\item{features}{A GRanges object representing a set of genomic coordinates.
The meta-plot will be centered on the transcription start site (TSS)}

\item{reads}{A GRanges object representing a set of mapped reads.
Instead of 'reads', 'plusCVG' and 'minusCVG' can be used  Default: NULL}

\item{plusCVG}{An IntegerRangesList object for reads with '+' strand.}

\item{minusCVG}{An IntegerRangesList object for reads with '-' strand.}

\item{size}{The size of the moving window.}

\item{up}{Distance upstream of each features to align and histogram.
Default: 10 kb.}

\item{down}{Distance downstream of each features to align and histogram.
If NULL, same as up. Default: NULL.}

\item{...}{Extra argument passed to mclapply}
}
\value{
Returns a integer-Rle representing the 'typical' signal
centered on a point of interest.
}
\description{
Supports parallel processing using mclapply in the 'parallel' package.
To change the number of processors, set the option 'mc.cores'.
}
\examples{
features <- GRanges("chr7", IRanges(1000, 1000), strand="+")
reads <- GRanges("chr7", IRanges(start=c(1000:1004, 1100),
 width=rep(1, 6)), strand="+")
mg <- metaGene(features, reads, size=4, up=10)
}
\author{
Charles G. Danko and Minho Chae
}
