% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{intern.estim}
\alias{intern.estim}
\title{Internal function}
\usage{
intern.estim(y, offset = NULL)
}
\arguments{
\item{y}{random variable: numeric vector of length \code{n}}

\item{offset}{numeric vector of length \code{n}}
}
\value{
The function returns a list of numeric vectors.
}
\description{
This functions estimates the parameters of the negative binomial
distribution by maximum likelihood. It is called by the functions
\code{\link{omnibus}} and \code{\link{proprius}}.
}
\details{
We assume the negative binomial distribution \code{y_i ~ NB(mu,phi)},
where the samples are indexed by \code{i} (\code{i=1,...,n}).
Our parametrisation leads to \code{E[y]= mu} 
and \code{Var[y]= mu + phi*mu^2}.
With the an offset the model becomes \code{y_i ~ NB(a_i*mu,phi)},
where the \code{a_i} are known.
}
\examples{
set.seed(1)
y <- rnbinom(n=1000,mu=10,size=1/0.2)
intern.estim(y)

}
\references{
A Rauschenberger, MA Jonker, MA van de Wiel, and RX Menezes (2016).
"Testing for association between RNA-Seq and high-dimensional data",
\emph{BMC Bioinformatics}. 17:118.
\href{http://dx.doi.org/10.1186/s12859-016-0961-5}{html}
\href{http://www.biomedcentral.com/content/pdf/s12859-016-0961-5.pdf}{pdf}
(open access)
}
\seealso{
This is an \code{\link{internal}} function. The user functions
are \code{\link{cursus}}, \code{\link{omnibus}},
and \code{\link{proprius}}.
}
\keyword{internal}
