% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position_identityx.r
\name{position_identityx}
\alias{position_identityx}
\title{adjust identity position which can be shifted vertically or horizontally.}
\usage{
position_identityx(hexpand = NA, vexpand = NA)
}
\arguments{
\item{hexpand}{numeric, distance to be shifted horizontally for geoms that
have a position, default is NA.}

\item{vexpand}{numeric, distance to be shifted vertically for geoms that
have a position, default is NA.}
}
\value{
position method.
}
\description{
adjust identity position which can be shifted vertically or horizontally.
}
\examples{
library(ggplot2)
library(patchwork)
p <- ggplot(mtcars, aes(x=wt, y=mpg))
p1 <- p + geom_point(position=position_identityx()) + ylim(0, 50)
# whole point layer was shifted vertically (distance=5).
# the label of axis y should be subtracted 5 to get the true value..
p2 <- p + geom_point(position=position_identityx(vexpand=5)) + ylim(0, 50)
# whole point layer was shifted horizontally (distance=5).
# the label of axis x should be subtracted 5 to get the true value.
p3 <- ggplot(mtcars, aes(y=wt, x=mpg)) +
      geom_point(position=position_identityx(hexpand=5)) + xlim(0, 50)
p4 <- p1 + p2 + p3
p4
}
\seealso{
Other position adjustments: 
\code{\link{position_dodgex}()},
\code{\link{position_points_sinax}()}
}
\author{
Shuangbin Xu
}
\concept{position adjustments}
