% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc-dim-utilities.R
\name{sc_dim_geom_label}
\alias{sc_dim_geom_label}
\title{sc_dim_geom_label}
\usage{
sc_dim_geom_label(geom = ggplot2::geom_text, mapping = NULL, ...)
}
\arguments{
\item{geom}{geometric layer (default: geom_text) to display the lables}

\item{mapping}{aesthetic mapping}

\item{...}{additional parameters pass to the geom}
}
\value{
layer of labels
}
\description{
sc_dim_geom_label
}
\examples{
library(scuttle)
library(scater)
library(scran)
library(ggplot2)
sce <- mockSCE()
sce <- logNormCounts(sce)
clusters <- clusterCells(sce, assay.type = 'logcounts')
colLabels(sce) <- clusters
sce <- runUMAP(sce, assay.type = 'logcounts')
p1 <- sc_dim(sce, reduction = 'UMAP', mapping = aes(colour = Cell_Cycle))
p2 <- sc_dim(sce, reduction = 'UMAP')
f1 <- p1 + sc_dim_geom_label()
}
\seealso{
\code{\link[=sc_dim_geom_label]{sc_dim_geom_label()}}
}
