% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlight_functions.R
\name{highlight_module}
\alias{highlight_module}
\title{highlight_module}
\usage{
highlight_module(graph, kmo, name = "name", sep = " ", verbose = FALSE)
}
\arguments{
\item{graph}{tbl_graph}

\item{kmo}{kegg_module class object which stores reaction}

\item{name}{which column to search for}

\item{sep}{separator for node names}

\item{verbose}{show messages or not}
}
\value{
boolean vector
}
\description{
identify if edges are involved in module reaction, and whether 
linked compounds are involved in the reaction. It would not be exactly 
the same as KEGG mapper. For instance, `R04293` involved in `M00912` 
is not included in KGML of `ko01100`.
}
\examples{
## Highlight module within the pathway
graph <- create_test_pathway()
mo <- create_test_module()
graph <- graph |> highlight_module(mo)

}
