% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales_logicle.R
\name{scale_x_logicle}
\alias{scale_x_logicle}
\alias{scale_y_logicle}
\title{Add a logicle scale to the x or y axes of a ggcyto plot.}
\usage{
scale_x_logicle(..., w = 0.5, t = 262144, m = 4.5, a = 0)

scale_y_logicle(..., w = 0.5, t = 262144, m = 4.5, a = 0)
}
\arguments{
\item{...}{common continuous scale parameters passed to 'continuous_scale' (not used currently)}

\item{w, t, m, a}{see 'help(logicleTransform')}
}
\value{
ScaleContinuous object
}
\description{
Add a logicle scale to the x or y axes of a ggcyto plot.
}
\examples{
data(GvHD)
fr <- GvHD[[1]]
p <- ggcyto(fr, aes(x = `FL1-H`)) + geom_density()
#display at raw scale
p 
#display at transformed scale
p + scale_x_logicle(t = 1e4)
}
