% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales_flowCore_fasinh.R
\name{scale_x_flowCore_fasinh}
\alias{scale_x_flowCore_fasinh}
\alias{scale_y_flowCore_fasinh}
\title{Add a flowCore inverse hyperbolic sine scale to the x or y axes of a ggcyto plot.}
\usage{
scale_x_flowCore_fasinh(..., a = 1, b = 1, c = 0)

scale_y_flowCore_fasinh(..., a = 1, b = 1, c = 0)
}
\arguments{
\item{...}{common continuous scale parameters passed to 'continuous_scale' (not used currently)}

\item{a, b, c}{see 'help(arcsinhTransform')}
}
\value{
ScaleContinuous object
}
\description{
Add a flowCore inverse hyperbolic sine scale to the x or y axes of a ggcyto plot.
}
\examples{
data(GvHD)
fr <- GvHD[[1]]
p <- ggcyto(fr, aes(x = `FL1-H`)) + geom_density()
#display at raw scale
p 
#display at transformed scale
p + scale_x_flowCore_fasinh(a = 2)
}
