% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales_flowJo_biexp.R
\name{scales_flowjo_biexp}
\alias{scales_flowjo_biexp}
\alias{scale_x_flowjo_biexp}
\alias{scale_y_flowjo_biexp}
\alias{scale_x_flowJo_biexp}
\alias{scale_y_flowJo_biexp}
\title{Add a flowJo biexponential scale to the x or y axes of a ggcyto plot.}
\usage{
scale_x_flowjo_biexp(
  ...,
  maxValue = 262144,
  widthBasis = -10,
  pos = 4.5,
  neg = 0,
  equal.space = FALSE
)

scale_y_flowjo_biexp(
  ...,
  maxValue = 262144,
  widthBasis = -10,
  pos = 4.5,
  neg = 0,
  equal.space = FALSE
)
}
\arguments{
\item{...}{common continuous scale parameters passed to 'continuous_scale' (not used currently)}

\item{maxValue, widthBasis, pos, neg}{see 'help(flowjo_biexp')}

\item{equal.space}{whether to display the breaks in equal.space format}
}
\value{
ScaleContinuous object
}
\description{
Add a flowJo biexponential scale to the x or y axes of a ggcyto plot.
}
\examples{
data(GvHD)
fr <- GvHD[[1]]
p <- ggcyto(fr, aes(x = `FL1-H`)) + geom_density()
#display at raw scale
p 
#display at transformed scale
p + scale_x_flowjo_biexp(maxValue = 1e4, widthBasis = 0)
}
