% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gep2pep.R
\name{clearCache}
\alias{clearCache}
\title{Clear cached ranked matrices}
\usage{
clearCache(rp_peps)
}
\arguments{
\item{rp_peps}{A repository created with
\code{\link{createRepository}}, and containing PEPs created
with \code{\link{buildPEPs}}.}
}
\value{
Nothing, used for side effects
}
\description{
Clear cached ranked matrices
}
\details{
This will clear everything in the repository tagged with
"stashed", which by default includes only matrices ranked by some
gep2pep functions such as \code{CondSEA}.
}
\examples{
db <- loadSamplePWS()
repo_path <- file.path(tempdir(), "gep2pepTemp")

rp <- createRepository(repo_path, db)
geps <- loadSampleGEP()
buildPEPs(rp, geps)

pgset <- c("(+)_chelidonine", "(+/_)_catechin")
psea <- CondSEA(rp, pgset, usecache=TRUE)

## the repository contains cached data
print(rp, all=TRUE)

clearCache(rp)

unlink(repo_path, TRUE)
}
\seealso{
CondSEA
}
