% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.r
\name{giLikelihood}
\alias{giLikelihood}
\title{Genomic instability likelihood}
\usage{
giLikelihood(
  inferCNV,
  recompute = TRUE,
  distros = c(1, 3),
  tumor = NULL,
  normal = NULL
)
}
\arguments{
\item{inferCNV}{InferCNV-class object}

\item{recompute}{Logical, whether the model fits should be re-computed}

\item{distros}{Vector of 2 integers indicating the minimum and maximum number
of Gaussian models to fit}

\item{tumor}{Optional vector of integers indicating the Gaussians considered
as tumors}

\item{normal}{Optional vector of integers indicating the Gaussians considered
as normal. This is only useful when no null model has been provided for the
analysis}
}
\value{
Updated inferCNV-class object with gi_likelihood slot
}
\description{
This function computes the genomic instability likelihood
}
\examples{

eh <- ExperimentHub::ExperimentHub()
dset <- eh[["EH5419"]]
tpm_matrix <- SummarizedExperiment::assays(dset)$TPM
set.seed(1)
tpm_matrix <- tpm_matrix[, sample(ncol(tpm_matrix), 500)]
cnv <- inferCNV(tpm_matrix)
cnv <- genomicInstabilityScore(cnv)
cnv <- giLikelihood(cnv, distros=c(3, 3), tumor=2:3)
print(cnv$gi_fit)
plot(density(cnv$gi_likelihood, from=0, to=1))

}
\seealso{
[genomicInstabilityScore()] to estimate the genomic instability
score for each cell in the dataset, and [inferCNV()] to infer the enrichment
of loci-blocks in the gene expression data.
}
