% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.r
\name{genomicInstabilityScore}
\alias{genomicInstabilityScore}
\title{Genomic Instability Analysis}
\usage{
genomicInstabilityScore(cnv, likelihood = FALSE)
}
\arguments{
\item{cnv}{Object of class inferCNV generated by inferCNV() function}

\item{likelihood}{Logical, whether the genomic instability likelihood should
be estimated}
}
\value{
Object of class inferCNV with updated slots for gis and gisnull
}
\description{
This function computes the genomic instability for an object of class
inferCNV
}
\examples{

eh <- ExperimentHub::ExperimentHub()
dset <- eh[["EH5419"]]
tpm_matrix <- SummarizedExperiment::assays(dset)$TPM
set.seed(1)
tpm_matrix <- tpm_matrix[, sample(ncol(tpm_matrix), 500)]
cnv <- inferCNV(tpm_matrix)
cnv <- genomicInstabilityScore(cnv)
plot(density(cnv$gis))

}
\seealso{
[inferCNV()] to infer the enrichment of loci-blocks in the gene
expression data.
}
