% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readData.R
\docType{methods}
\name{readBed}
\alias{readBed}
\title{Read a BED file and convert it to GRanges.}
\usage{
readBed(file, track.line = FALSE, remove.unusual = FALSE,
  zero.based = TRUE)
}
\arguments{
\item{file}{location of the file, a character string such as: "/home/user/my.bed"
or the input itself as a string (containing at least one \\n).
The file can end in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip}
and/or start with \code{http://} or \code{ftp://}. If the file is not 
compressed it can also start with \code{https://} or \code{ftps://}.}

\item{track.line}{the number of track lines to skip, "auto" to detect them 
automatically or FALSE(default) if the bed file doesn't 
have track lines}

\item{remove.unusual}{if TRUE remove the chromosomes with unsual 
names, such as chrX_random (Default:FALSE)}

\item{zero.based}{a boolean which tells whether the ranges in 
the bed file are 0 or 1 base encoded. (Default: TRUE)}
}
\value{
\code{\link{GRanges}} object
}
\description{
The function reads a BED file that contains location and other information
on genomic features and returns a \code{\link{GRanges}} object. 
The minimal information that the BED file has to have is chromosome, 
start and end columns. it can handle all BED formats up to 12 columns.
}
\examples{
my.file=system.file("extdata","chr21.refseq.hg19.bed",package="genomation")
refseq = readBed(my.file,track.line=FALSE,remove.unusual=FALSE)
head(refseq)

}
