% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpearmanCI.R
\name{spearmanCI}
\alias{spearmanCI}
\title{Function to compute the confidence interval for the Spearman
correelation coefficient}
\usage{
spearmanCI(x, n, alpha = 0.05)
}
\arguments{
\item{x}{Spearman correlation coefficient rho.}

\item{n}{the sample size used to compute the Spearman rho.}

\item{alpha}{alpha level for confidence interval.}
}
\value{
A vector containing the lower, upper values for the confidence interval
and p-value for Spearman rho
}
\description{
This function enables to compute the confidence interval for the Spearman
correelation coefficient using the Fischer Z transformation.
}
\examples{
spearmanCI(x=0.2, n=100, alpha=0.05)

}
