% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.datasets.R
\name{map.datasets}
\alias{map.datasets}
\title{Function to map a list of datasets through EntrezGene IDs in order to
get the union of the genes}
\usage{
map.datasets(datas, annots, do.mapping = FALSE, 
  mapping.coln = "EntrezGene.ID", mapping, verbose = FALSE)
}
\arguments{
\item{datas}{List of matrices of gene expressions with samples in rows and
probes in columns, dimnames being properly defined.}

\item{annots}{List of matrices of annotations with at least one column named
"EntrezGene.ID", dimnames being properly defined.}

\item{do.mapping}{TRUE if the mapping through Entrez Gene ids must be
performed (in case of ambiguities, the most variant probe is kept for each
gene), FALSE otherwise.}

\item{mapping.coln}{Name of the column containing the biological annotation
to be used to map the different datasets, default is "EntrezGene.ID".}

\item{mapping}{Matrix with columns "EntrezGene.ID" and "probe.x" used to
force the mapping such that the probes of platform x are not selected based on
their variance.}

\item{verbose}{TRUE to print informative messages, FALSE otherwise.}
}
\value{
A list with items:
\itemize{
\item datas: List of datasets (gene expression matrices)
\item annots: List of annotations (annotation matrices)
}
}
\description{
This function maps a list of datasets through EntrezGene IDs in order to get
the union of the genes.
}
\details{
In case of several probes representing the same EntrezGene ID, the most
variant is selected if mapping is not specified. When a EntrezGene ID does not
exist in a specific dataset, NA values are introduced.
}
\examples{
# load VDX dataset
data(vdxs)
# load NKI dataset
data(nkis)
# reduce datasets
ginter <- intersect(annot.vdxs[ ,"EntrezGene.ID"], annot.nkis[ ,"EntrezGene.ID"])
ginter <- ginter[!is.na(ginter)][1:30]
myx <- unique(c(match(ginter, annot.vdxs[ ,"EntrezGene.ID"]),
  sample(x=1:nrow(annot.vdxs), size=20)))
data2.vdxs <- data.vdxs[ ,myx]
annot2.vdxs <- annot.vdxs[myx, ]
myx <- unique(c(match(ginter, annot.nkis[ ,"EntrezGene.ID"]),
  sample(x=1:nrow(annot.nkis), size=20)))
data2.nkis <- data.nkis[ ,myx]
annot2.nkis <- annot.nkis[myx, ]
# mapping of datasets
datas <- list("VDX"=data2.vdxs,"NKI"=data2.nkis)
annots <- list("VDX"=annot2.vdxs, "NKI"=annot2.nkis)
datas.mapped <- map.datasets(datas=datas, annots=annots, do.mapping=TRUE)
str(datas.mapped, max.level=2)

}
