% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.proto.cor.meta.R
\name{compute.proto.cor.meta}
\alias{compute.proto.cor.meta}
\title{Function to compute correlations to prototypes in a
meta-analytical framework}
\usage{
compute.proto.cor.meta(datas, proto, method = c("pearson", "spearman"))
}
\arguments{
\item{datas}{List of datasets. Each dataset is a matrix of gene expressions with samples
in rows and probes in columns, dimnames being properly defined. All the datasets must have the same probes.}

\item{proto}{Names of prototypes (e.g. their EntrezGene ID).}

\item{method}{Estimator for correlation coefficient, can be either pearson or spearman}
}
\value{
A list with items:
-cor Matrix of meta-estimate of correlation coefficients with probes in rows and prototypes in columns.
-cor.n Number of samples used to compute meta-estimate of correlation coefficients.
}
\description{
This function computes meta-estimate of correlation coefficients between a set of genes
and a set of prototypes from a list of gene expression datasets.
}
\examples{
# load VDX dataset
data(vdxs)
# load NKI dataset
data(nkis)
# reduce datasets
ginter <- intersect(annot.vdxs[ ,"EntrezGene.ID"], annot.nkis[ ,"EntrezGene.ID"])
ginter <- ginter[!is.na(ginter)][1:30]
myx <- unique(c(match(ginter, annot.vdxs[ ,"EntrezGene.ID"]),
  sample(x=1:nrow(annot.vdxs), size=20)))
data2.vdxs <- data.vdxs[ ,myx]
annot2.vdxs <- annot.vdxs[myx, ]
myx <- unique(c(match(ginter, annot.nkis[ ,"EntrezGene.ID"]),
  sample(x=1:nrow(annot.nkis), size=20)))
data2.nkis <- data.nkis[ ,myx]
annot2.nkis <- annot.nkis[myx, ]
# mapping of datasets
datas <- list("VDX"=data2.vdxs,"NKI"=data2.nkis)
annots <- list("VDX"=annot2.vdxs, "NKI"=annot2.nkis)
datas.mapped <- map.datasets(datas=datas, annots=annots, do.mapping=TRUE)
# define some prototypes
protos <- paste("geneid", ginter[1:3], sep=".")
# compute meta-estimate of correlation coefficients to the three prototype genes
probecor <- compute.proto.cor.meta(datas=datas.mapped$datas, proto=protos,
  method="pearson")
str(probecor)

}
\seealso{
\link{map.datasets}
}
