% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenericFunctions.R,
%   R/Class_FixedExpressionData.R, R/Class_ClassifierParameters.R
\docType{methods}
\name{getNormalizationMethod}
\alias{getNormalizationMethod}
\alias{getNormalizationMethods}
\alias{getNormalizationMethod,FixedExpressionData-method}
\alias{getNormalizationMethod,ClassifierParameters-method}
\title{Obtain normalization method}
\usage{
getNormalizationMethod(object)

getNormalizationMethods()

\S4method{getNormalizationMethod}{FixedExpressionData}(object)

\S4method{getNormalizationMethod}{ClassifierParameters}(object)
}
\arguments{
\item{object}{An object of class \code{\link{FixedExpressionData}} or
\code{\link{ClassifierParameters}}}
}
\value{
A character string indicating the normalization method.
}
\description{
The function \code{getNormalizationMethod} returns the normalization method
associated with the object

\code{getNormalizationMethods} returns a character vector of 
currenlty available normalization methods.
}
\details{
The given normlization methods can be used in the
}
\examples{
data(exampleMAS5)
myData <- setNormalizationMethod(exampleMAS5, "MAS5.0", targetValue=500)
aClassifier <- getClassifier("EMC92")
getNormalizationMethod( myData )
getNormalizationMethod( aClassifier )
data(exampleMAS5)

showClassifierList()
getNormalizationMethods()

myData <- setNormalizationMethod(exampleMAS5, "MAS5.0",targetValue=500)
results <- runClassifier('UAMS70', myData)

getScores( results )
getClassifications( results )

}
\seealso{
\code{\link{getNormalizationMethods}}

Other classifier information functions: \code{\link{getCitations}},
  \code{\link{getClassifier}},
  \code{\link{getDecisionBoundaries}},
  \code{\link{getDescription}},
  \code{\link{getEventChain}}, \code{\link{getIntercept}},
  \code{\link{getMeans}}, \code{\link{getProbeNames}},
  \code{\link{getSds}}, \code{\link{getTrainingData}},
  \code{\link{getWeights}}

Other fixed data information extraction functions: \code{\link{[,FixedExpressionData,ANY,ANY-method}},
  \code{\link{dim,FixedExpressionData-method}},
  \code{\link{getTargetValue}}

Other workflow functions: \code{\link{runClassifier}},
  \code{\link{setNormalizationMethod}},
  \code{\link{showClassifierList}}
}
\concept{classifier information functions}
\concept{fixed data information extraction functions}
\concept{workflow functions}
