% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenericFunctions.R,
%   R/Class_ClassifierParameters.R
\docType{methods}
\name{getDecisionBoundaries}
\alias{getDecisionBoundaries}
\alias{getDecisionBoundaries,ClassifierParameters-method}
\title{Obtain the decision boundaries defined for the classifier.}
\usage{
getDecisionBoundaries(object)

\S4method{getDecisionBoundaries}{ClassifierParameters}(object)
}
\arguments{
\item{object}{An object of class \code{\link{ClassifierParameters}}
as returned by \code{\link{getClassifier}}}
}
\value{
A numeric vector
}
\description{
\code{getDecisionBoundaries} returns the a numeric vector
 of boundary values that separate the risk groups.
}
\examples{
aClassifier <- getClassifier("EMC92")
getDecisionBoundaries(aClassifier)
}
\seealso{
Other classifier information functions: \code{\link{getCitations}},
  \code{\link{getClassifier}},
  \code{\link{getDescription}},
  \code{\link{getEventChain}}, \code{\link{getIntercept}},
  \code{\link{getMeans}},
  \code{\link{getNormalizationMethod}},
  \code{\link{getProbeNames}}, \code{\link{getSds}},
  \code{\link{getTrainingData}}, \code{\link{getWeights}}
}
\concept{classifier information functions}
