% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{get_dataset_object}
\alias{get_dataset_object}
\title{Compile gene expression data and metadata}
\usage{
get_dataset_object(
  datasets,
  genes = NULL,
  keepNonSpecific = FALSE,
  consolidate = NA_character_,
  resultSets = NULL,
  contrasts = NULL,
  metaType = "text",
  type = "se",
  memoised = getOption("gemma.memoised", FALSE)
)
}
\arguments{
\item{datasets}{A vector of dataset IDs or short names}

\item{genes}{A vector of NCBI IDs, Ensembl IDs or gene symbols.}

\item{keepNonSpecific}{logical. \code{FALSE} by default. If \code{TRUE}, results
from probesets that are not specific to the gene will also be returned.}

\item{consolidate}{An option for gene expression level consolidation. If empty,
will return every probe for the genes. "pickmax" to
pick the probe with the highest expression, "pickvar" to pick the prove with
the highest variance and "average" for returning the average expression}

\item{resultSets}{Result set IDs of the a differential expression analysis. Optional. If provided, the output will only include
the samples from the subset used in the result set ID.
Must be the same length as \code{datasets}.'}

\item{contrasts}{Contrast IDs of a differential expression contrast. Optional. Need resultSets to be defined to work. If provided, the
output will only include samples relevant to the specific contrats.}

\item{metaType}{How should the metadata information should be included. Can be "text", "uri" or "both". "text" and "uri" options}

\item{type}{"se"for a SummarizedExperiment or "eset" for Expression Set. We recommend using
SummarizedExperiments which are more recent. See the Summarized experiment
\href{https://bioconductor.org/packages/release/bioc/vignettes/SummarizedExperiment/inst/doc/SummarizedExperiment.html}{vignette}
or the ExpressionSet \href{https://bioconductor.org/packages/release/bioc/vignettes/Biobase/inst/doc/ExpressionSetIntroduction.pdf}{vignette}
for more details. "tidy" for a long form data frame compatible with tidyverse functions.
'list' to return a list containing individual data frames containing expression values,
design and the experiment.}

\item{memoised}{Whether or not to save to cache for future calls with the
same inputs and use the result saved in cache if a result is already saved.
Doing \code{options(gemma.memoised = TRUE)} will ensure that the cache is always
used. Use \code{\link{forget_gemma_memoised}} to clear the cache.}
}
\value{
A list of \code{\link[SummarizedExperiment]{SummarizedExperiment}}s,
\code{\link[Biobase]{ExpressionSet}}s or a tibble containing metadata and
expression data for the queried datasets and genes. Metadata will be expanded to include
a variable number of factors that annotates samples from a dataset but will
always include single "factorValues" column that houses data.tables that
include all annotations for a given sample.
}
\description{
Return an annotated Bioconductor-compatible
data structure or a long form tibble of the queried dataset, including
expression data and the experimental design.
}
\examples{
get_dataset_object("GSE2018")
}
\keyword{dataset}
