% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{get_dataset_expression_for_genes}
\alias{get_dataset_expression_for_genes}
\title{Retrieve the expression data matrix of a set of datasets and genes}
\usage{
get_dataset_expression_for_genes(
  datasets,
  genes,
  keepNonSpecific = FALSE,
  consolidate = NA_character_,
  raw = getOption("gemma.raw", FALSE),
  memoised = getOption("gemma.memoised", FALSE),
  file = getOption("gemma.file", NA_character_),
  overwrite = getOption("gemma.overwrite", FALSE)
)
}
\arguments{
\item{datasets}{A vector of dataset IDs or short names}

\item{genes}{A vector of NCBI IDs, Ensembl IDs or gene symbols.}

\item{keepNonSpecific}{logical. \code{FALSE} by default. If \code{TRUE}, results
from probesets that are not specific to the gene will also be returned.}

\item{consolidate}{An option for gene expression level consolidation. If empty,
will return every probe for the genes. "pickmax" to
pick the probe with the highest expression, "pickvar" to pick the prove with
the highest variance and "average" for returning the average expression}

\item{raw}{\code{TRUE} to receive results as-is from Gemma, or \code{FALSE} to enable
parsing. Raw results usually contain additional fields and flags that are
omitted in the parsed results.}

\item{memoised}{Whether or not to save to cache for future calls with the
same inputs and use the result saved in cache if a result is already saved.
Doing \code{options(gemma.memoised = TRUE)} will ensure that the cache is always
used. Use \code{\link{forget_gemma_memoised}} to clear the cache.}

\item{file}{The name of a file to save the results to, or \code{NULL} to not write
results to a file. If \code{raw == TRUE}, the output will be the raw endpoint from the
API, likely a JSON or a gzip file. Otherwise, it will be a RDS file.}

\item{overwrite}{Whether or not to overwrite if a file exists at the specified
filename.}
}
\value{
A list of data frames
}
\description{
Retrieve the expression data matrix of a set of datasets and genes
}
\examples{
get_dataset_expression_for_genes("GSE2018", genes = c(10225, 2841))
}
\keyword{dataset}
