% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize_x.R
\name{initialize_x}
\alias{initialize_x}
\title{intialize_x}
\usage{
initialize_x(Model, concordance = 1, cores = 1, verbose = FALSE)
}
\arguments{
\item{Model}{a Model object of class gemini.model}

\item{concordance}{a numeric value to initialize x}

\item{cores}{a numeric indicating the number of cores to use.  See \code{\link[gemini]{gemini_parallelization}} default 1.}

\item{verbose}{default FALSE}
}
\value{
a Model object of class gemini.model including new slots for x values and internal-use hashes
}
\description{
Initialize all x values to the value of \code{concordance}
}
\note{
As there is much hashing involved in this function, this tends to be computationally intensive.
As such, we have enabled parallelization of most hash steps, but this may still be rate-limited by the 
amount of memory consumed.
}
\examples{
data("Model", package = "gemini")
Model \%<>\% initialize_x()

}
