% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini_inference.R
\name{gemini_inference}
\alias{gemini_inference}
\title{gemini_inference}
\usage{
gemini_inference(
  Model,
  n_iterations = 20,
  mean_x = 1,
  sd_x = 1,
  mean_xx = 1,
  sd_xx = 1,
  mean_y = 0,
  sd_y = 10,
  mean_s = 0,
  sd_s = 10,
  threshold = 0.001,
  cores = 1,
  force_results = FALSE,
  verbose = FALSE,
  save_iterations = FALSE
)
}
\arguments{
\item{Model}{an object of class gemini.model}

\item{n_iterations}{a numeric indicating the maximum number of iterations (default=20).}

\item{mean_x}{a numeric indicating prior mean of x (default=1).}

\item{sd_x}{a numeric indicating prior sd of x (default=1).}

\item{mean_xx}{a numeric indicating prior mean of xx (default=1).}

\item{sd_xx}{a numeric indicating prior sd of xx (default=1)}

\item{mean_y}{a numeric indicating prior mean of y (default=0)}

\item{sd_y}{a numeric indicating prior sd of y (default=10).}

\item{mean_s}{a numeric indicating prior mean of s(default=0)}

\item{sd_s}{a numeric indicating prior sd of s (default=10)}

\item{threshold}{a numeric indicating the threshold of change in MAE at which to stop the iterative process (default=0.001).}

\item{cores}{a numeric indicating the number of cores to use.  See details in gemini_parallel. (default=1)}

\item{force_results}{a logical indicating if the CAVI algorithm should be halted if non-convergence is detected. (default=FALSE)}

\item{verbose}{default FALSE}

\item{save_iterations}{for especially large libraries that require long computations,
saves the latest iteration of each update.  default FALSE}
}
\value{
a gemini.model object with estimated posteriors
}
\description{
Estimate the posterior using a variational inference technique. Inference is performed
through an iterative process until convergence.
}
\details{
GEMINI uses the following parameters, which are described in Zamanighomi et al. and translated here for clarity:
\itemize{
\item \strong{y:} individual gene effect
\item \strong{s:} combination effect
\item \strong{x:} screen variation corresponding to individual guides
\item \strong{xx:} screen variation corresponding to paired guides
}

Default parameters may need to be changed if convergence is not achieved. See README for
more details.
}
\examples{
data("Model", package = "gemini")
Model \%<>\% gemini_inference(verbose = FALSE, n_iterations = 1) # iterations set to 1 for testing

}
